(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    106681,       2199]
NotebookOptionsPosition[    106158,       2181]
NotebookOutlinePosition[    106589,       2198]
CellTagsIndexPosition[    106546,       2195]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"VectorQ", "[", "GVl20", "]"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{"GVl20", ",", "Null"}], "]"}], "\[Equal]", "False"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GVl20", "\[NotEqual]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MatrixQ", "[", "GVl21", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"ToCharacterCode", "[", 
                 RowBox[{"ToString", "[", "GVl21", "]"}], "]"}], ",", 
                "62760"}], "]"}], "\[Equal]", "False"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Dimensions", "[", "GVl21", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", "GVl21", "]"}], ",", "Null"}], 
                   "]"}], "\[Equal]", "False"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"IntegerQ", "[", "GVl22", "]"}], "&&", 
                    RowBox[{"GVl22", "\[GreaterEqual]", "1"}]}], ",", 
                   RowBox[{"Column", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar18", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{"GVl21", ",", 
                    RowBox[{"vertices", "\[Rule]", "GVl20"}]}], "]"}]}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"MatrixPower", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MGrafo", "[", 
                    RowBox[{"GGrafoAuxiliar18", ",", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar18", "]"}], 
                    "]"}]}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "Gi18"}], "]"}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar18", "]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar18", "]"}], 
                    "]"}]}]}], "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
                   RowBox[{"GVl22", "=", "10"}]}], "]"}], ",", "\"\<\>\""}], 
                "]"}], ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], 
           ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
       "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Elementos del grafo\>\"", ",", "Bold", ",", "Medium"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"GVl20", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      "\"\<V\[EAcute]rtices\>\""}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"GVl21", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", "c"}], "}"}]}], "}"}], ",", "\"\<Aristas\>\""}], 
     "}"}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Potencias\>\"", ",", "Bold", ",", "Medium"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"GVl22", ",", "10", ",", "\"\<M\[AAcute]ximo valor de k\>\""}], 
     "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Gi18", ",", "1", ",", "\"\<k\>\""}], "}"}], ",", "1", ",", 
     "GVl22", ",", "1"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Clear", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "Grafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
         RowBox[{"vertices", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"pesos", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"Grafo", "[", 
        RowBox[{"GAristas_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "GAristasNoDirigidas", ",", "GAristasDirigidas", ",", 
           "GLabelsPesos", ",", "Grafo3d", ",", "GrafoNo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GAristasNoDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador4_", "\[Rule]", 
               RowBox[{"UndirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GAristasDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador5_", "\[Rule]", 
               RowBox[{"DirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GLabelsPesos", "[", 
            RowBox[{"GGrafo_", ",", "GPesos_"}], "]"}], ":=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", "GPesos", "]"}], "\[Equal]", 
              RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GList1", "=", 
                  RowBox[{"EdgeList", "[", "GGrafo", "]"}]}], ",", 
                 RowBox[{"GList2", "=", 
                  RowBox[{"{", "}"}]}]}], "}"}], ",", 
               RowBox[{
                RowBox[{"For", "[", 
                 RowBox[{
                  RowBox[{"Gi1", "=", "1"}], ",", 
                  RowBox[{"Gi1", "\[LessEqual]", 
                   RowBox[{"Length", "[", "GList1", "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"GList2", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"GList2", ",", 
                    RowBox[{
                    RowBox[{"GList1", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}], "\[Rule]", 
                    RowBox[{"GPesos", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}]}]}], "]"}]}], ";", 
                   RowBox[{"Gi1", "++"}]}]}], "]"}], ";", "GList2"}]}], 
              "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"Grafo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoNo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                  "Null"}], "]"}], "\[Equal]", "False"}], "&&", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}], 
                 "]"}], "\[Equal]", "False"}]}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MatrixQ", "[", "GAristas", "]"}], "||", 
                   RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ")"}], "&&", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", "GAristas", "]"}], ",", "Null"}], 
                   "]"}], "\[Equal]", "False"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
                   RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "\[Equal]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"{", "}"}]}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"MatrixQ", "[", "GAristas", "]"}], "&&", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "GAristas", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "GAristas", "]"}], "]"}], ",", 
                    "62760"}], "]"}], "\[Equal]", "False"}]}], ")"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                    RowBox[{"Grafo3d", "[", "GAristas", "]"}], ",", 
                    RowBox[{"GrafoNo3d", "[", "GAristas", "]"}]}], "]"}]}], 
                   "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"GrafoQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GraphQ", "[", "GGrafo", "]"}], ",", "True", ",", "False"}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoCQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumericQ", "[", 
          RowBox[{"V", "[", "GGrafo", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"V", "[", "GGrafo", "]"}], "\[Equal]", "0"}], ",", 
           "False", ",", "True"}], "]"}], ",", "False"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "MGrafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"table", "\[Rule]", "False"}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"MGrafo", "[", 
        RowBox[{"GGrafo_", ",", "GNodos_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "GGrafoAuxiliar3", "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"VectorQ", "[", "GNodos", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"GNodos", ",", "Null"}], "]"}], "\[Equal]", "False"}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GNodos", "\[NotEqual]", 
                RowBox[{"{", "}"}]}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"BooleanQ", "[", 
                  RowBox[{"OptionValue", "[", "table", "]"}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar3", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{"AdjacencyMatrix", "[", "GGrafoAuxiliar3", "]"}], 
                    "]"}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Normal", "@", 
                    RowBox[{
                    "AdjacencyMatrix", "[", "GGrafoAuxiliar3", "]"}]}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar3", "=", 
                    RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}], 
                    "]"}], "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar3", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"Edges", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"vertices", "\[Rule]", "GNodos"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", 
                    RowBox[{"!", 
                    RowBox[{"UndirectedQ", "[", "GGrafo", "]"}]}]}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{"AdjacencyMatrix", "[", "GGrafoAuxiliar3", "]"}], 
                    "]"}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Normal", "@", 
                    RowBox[{
                    "AdjacencyMatrix", "[", "GGrafoAuxiliar3", "]"}]}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar3", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"MBooleanQ", "[", "MatrizSBooleana_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatrixQ", "[", 
          RowBox[{"MatrizSBooleana", ",", "NumericQ"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Flatten", "[", "MatrizSBooleana", "]"}], ",", "Null"}],
              "]"}], "\[Equal]", "False"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MatrizSBooleana", "^", "2"}], "==", 
              "MatrizSBooleana"}], ",", "True", ",", "False"}], "]"}], ",", 
           "False"}], "]"}], ",", "False"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "CombinatoricaToGraph", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CombinatoricaToGraph", "[", 
        RowBox[{"GGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GrafoO3d", ",", "GrafoONo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GrafoO3d", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl2", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoONo3d", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl2", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                RowBox[{"GrafoO3d", "[", "GGrafo", "]"}], ",", 
                RowBox[{"GrafoONo3d", "[", "GGrafo", "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Matriz de adyacencia\>\"", ",", " ", "Bold", ",", " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6706699984561467`*^9, 3.670670054179222*^9}, {
   3.670670141309124*^9, 3.6706701421256437`*^9}, {3.670670174865549*^9, 
   3.670670175265642*^9}, {3.6706702278856173`*^9, 3.67067023053905*^9}, {
   3.6706702757706995`*^9, 3.6706702855948524`*^9}, {3.6706703995333977`*^9, 
   3.670670402605569*^9}, 3.801155591154818*^9, {3.801155639249878*^9, 
   3.8011556490240707`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"34240ed5-103e-465d-b9f4-95021ab796c5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Gi18$$ = 
    1, $CellContext`GVl20$$ = {$CellContext`a, $CellContext`b, \
$CellContext`c}, $CellContext`GVl21$$ = {{$CellContext`a, $CellContext`b}, \
{$CellContext`b, $CellContext`c}}, $CellContext`GVl22$$ = 10, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[
       Style["Elementos del grafo", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`GVl20$$], {$CellContext`a, $CellContext`b, \
$CellContext`c}, "V\[EAcute]rtices"}}, {{
       Hold[$CellContext`GVl21$$], {{$CellContext`a, $CellContext`b}, \
{$CellContext`b, $CellContext`c}}, "Aristas"}}, {
      Hold[
       Style["Potencias", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`GVl22$$], 10, "M\[AAcute]ximo valor de k"}}, {{
       Hold[$CellContext`Gi18$$], 1, "k"}, 1, 
      Dynamic[$CellContext`GVl22$$], 1}}, Typeset`size$$ = {270., {71., 80.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`Gi18$$ = 
        1, $CellContext`GVl20$$ = {$CellContext`a, $CellContext`b, \
$CellContext`c}, $CellContext`GVl21$$ = {{$CellContext`a, $CellContext`b}, \
{$CellContext`b, $CellContext`c}}, $CellContext`GVl22$$ = 10}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        VectorQ[$CellContext`GVl20$$], 
        If[MemberQ[$CellContext`GVl20$$, Null] == False, 
         If[$CellContext`GVl20$$ != {}, 
          If[
           MatrixQ[$CellContext`GVl21$$], 
           If[MemberQ[
              ToCharacterCode[
               ToString[$CellContext`GVl21$$]], 62760] == False, 
            If[Part[
               Dimensions[$CellContext`GVl21$$], 2] == 2, 
             If[MemberQ[
                Flatten[$CellContext`GVl21$$], Null] == False, 
              If[
               And[
                IntegerQ[$CellContext`GVl22$$], $CellContext`GVl22$$ >= 1], 
               
               Column[{$CellContext`GGrafoAuxiliar18 = \
$CellContext`Grafo[$CellContext`GVl21$$, $CellContext`vertices -> \
$CellContext`GVl20$$], 
                 TableForm[
                  MatrixPower[
                   Part[
                    $CellContext`MGrafo[$CellContext`GGrafoAuxiliar18, 
                    Sort[
                    VertexList[$CellContext`GGrafoAuxiliar18]]], 
                    1], $CellContext`Gi18$$], TableHeadings -> {
                    Map[Style[#, Black]& , 
                    Sort[
                    VertexList[$CellContext`GGrafoAuxiliar18]]], 
                    Map[Style[#, Black]& , 
                    Sort[
                    VertexList[$CellContext`GGrafoAuxiliar18]]]}, 
                  TableAlignments -> Center]}, Center], $CellContext`GVl22$$ = 
               10], ""], ""], ""], ""], ""], ""], ""], "Specifications" :> {
        Style[
        "Elementos del grafo", Bold, 
         Medium], {{$CellContext`GVl20$$, {$CellContext`a, $CellContext`b, \
$CellContext`c}, 
          "V\[EAcute]rtices"}}, {{$CellContext`GVl21$$, {{$CellContext`a, \
$CellContext`b}, {$CellContext`b, $CellContext`c}}, "Aristas"}}, Delimiter, 
        Style[
        "Potencias", Bold, 
         Medium], {{$CellContext`GVl22$$, 10, 
          "M\[AAcute]ximo valor de k"}}, {{$CellContext`Gi18$$, 1, "k"}, 1, 
         Dynamic[$CellContext`GVl22$$], 1}}, 
      "Options" :> {Alignment -> Center, FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["Matriz de adyacencia", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{624., {277., 286.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((Clear[$CellContext`a, $CellContext`b, $CellContext`c]; 
      Options[$CellContext`Grafo] = {$CellContext`dirigido -> 
         False, $CellContext`vertices -> {}, $CellContext`dimensions3d -> 
         False, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> False}; $CellContext`Grafo[
         Pattern[$CellContext`GAristas, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GAristasNoDirigidas, \
$CellContext`GAristasDirigidas, $CellContext`GLabelsPesos, \
$CellContext`Grafo3d, $CellContext`GrafoNo3d}, \
$CellContext`GAristasNoDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador4, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Gicontador4, 1], 
               
               Part[$CellContext`Gicontador4, 
                2]]]]; $CellContext`GAristasDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador5, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Gicontador5, 1], 
               Part[$CellContext`Gicontador5, 2]]]]; $CellContext`GLabelsPesos[
            Pattern[$CellContext`GGrafo, 
             Blank[]], 
            Pattern[$CellContext`GPesos, 
             Blank[]]] := 
          If[Length[$CellContext`GPesos] == EdgeCount[$CellContext`GGrafo], 
            
            Module[{$CellContext`GList1 = 
              EdgeList[$CellContext`GGrafo], $CellContext`GList2 = {}}, 
             For[$CellContext`Gi1 = 1, $CellContext`Gi1 <= 
               Length[$CellContext`GList1], $CellContext`GList2 = 
                Append[$CellContext`GList2, 
                  Part[$CellContext`GList1, $CellContext`Gi1] -> 
                  Part[$CellContext`GPesos, $CellContext`Gi1]]; 
               Increment[$CellContext`Gi1]]; $CellContext`GList2]]; \
$CellContext`Grafo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; $CellContext`GrafoNo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[
               OptionValue[$CellContext`pesos] == {}, $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dirigido]], 
            VectorQ[
             OptionValue[$CellContext`vertices]], 
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            VectorQ[
             OptionValue[$CellContext`pesos]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            And[MemberQ[
               OptionValue[$CellContext`vertices], Null] == False, MemberQ[
               OptionValue[$CellContext`pesos], Null] == False], 
            If[
             And[
              Or[
               MatrixQ[$CellContext`GAristas], 
               ToString[$CellContext`GAristas] == ToString[{}]], MemberQ[
                Flatten[$CellContext`GAristas], Null] == False], 
             If[
              Or[Length[$CellContext`GAristas] == Length[
                 OptionValue[$CellContext`pesos]], 
               OptionValue[$CellContext`pesos] == {}], 
              If[
               Or[
                And[
                ToString[$CellContext`GAristas] == ToString[{}], 
                 OptionValue[$CellContext`vertices] != {}], 
                And[
                 MatrixQ[$CellContext`GAristas], Part[
                   Dimensions[$CellContext`GAristas], 2] == 2, MemberQ[
                   ToCharacterCode[
                    ToString[$CellContext`GAristas]], 62760] == False]], 
               If[
                OptionValue[$CellContext`dimensions3d], 
                $CellContext`Grafo3d[$CellContext`GAristas], 
                $CellContext`GrafoNo3d[$CellContext`GAristas]]]]]]]]; \
$CellContext`GrafoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         GraphQ[$CellContext`GGrafo], True, False]; $CellContext`GrafoCQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         NumericQ[
          $CellContext`V[$CellContext`GGrafo]], 
         If[$CellContext`V[$CellContext`GGrafo] == 0, False, True], False]; 
      Options[$CellContext`MGrafo] = {$CellContext`table -> 
         False}; $CellContext`MGrafo[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         Pattern[$CellContext`GNodos, 
          Blank[]], 
         OptionsPattern[]] := Module[{$CellContext`GGrafoAuxiliar3}, 
         If[
          VectorQ[$CellContext`GNodos], 
          If[MemberQ[$CellContext`GNodos, Null] == False, 
           If[$CellContext`GNodos != {}, 
            If[
             BooleanQ[
              OptionValue[$CellContext`table]], 
             If[
              $CellContext`GrafoQ[$CellContext`GGrafo], 
              If[Sort[
                 VertexList[$CellContext`GGrafo]] == 
               Sort[$CellContext`GNodos], $CellContext`GGrafoAuxiliar3 = 
                Graph[$CellContext`GNodos, 
                  EdgeList[$CellContext`GGrafo], VertexLabels -> "Name", 
                  ImagePadding -> 10]; If[
                 Not[
                  OptionValue[$CellContext`table]], 
                 MatrixForm[
                  AdjacencyMatrix[$CellContext`GGrafoAuxiliar3]], 
                 TableForm[
                  Normal[
                   AdjacencyMatrix[$CellContext`GGrafoAuxiliar3]], 
                  TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar3]], 
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar3]]}, 
                  TableAlignments -> Center]]], 
              If[
               $CellContext`GrafoCQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar3 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; If[Sort[
                   VertexList[$CellContext`GGrafoAuxiliar3]] == 
                 Sort[$CellContext`GNodos], $CellContext`GGrafoAuxiliar3 = \
$CellContext`Grafo[
                    $CellContext`Edges[$CellContext`GGrafo], \
$CellContext`vertices -> $CellContext`GNodos, $CellContext`dirigido -> Not[
                    $CellContext`UndirectedQ[$CellContext`GGrafo]]]; If[
                   Not[
                    OptionValue[$CellContext`table]], 
                   MatrixForm[
                    AdjacencyMatrix[$CellContext`GGrafoAuxiliar3]], 
                   TableForm[
                    Normal[
                    AdjacencyMatrix[$CellContext`GGrafoAuxiliar3]], 
                    TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar3]], 
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar3]]}, 
                    TableAlignments -> 
                    Center]]]]]]]]]]; $CellContext`MBooleanQ[
         Pattern[$CellContext`MatrizSBooleana, 
          Blank[]]] := If[
         MatrixQ[$CellContext`MatrizSBooleana, NumericQ], 
         If[MemberQ[
            Flatten[$CellContext`MatrizSBooleana], Null] == False, 
          
          If[$CellContext`MatrizSBooleana^2 == $CellContext`MatrizSBooleana, 
           True, False], False], False]; 
      Options[$CellContext`CombinatoricaToGraph] = {$CellContext`dimensions3d -> 
         False, $CellContext`mostrarpesos -> False, $CellContext`shape -> 
         False}; $CellContext`CombinatoricaToGraph[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GrafoO3d, $CellContext`GrafoONo3d}, \
$CellContext`GrafoO3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; $CellContext`GrafoONo3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            $CellContext`GrafoCQ[$CellContext`GGrafo], 
            If[
             OptionValue[$CellContext`dimensions3d], 
             $CellContext`GrafoO3d[$CellContext`GGrafo], 
             $CellContext`GrafoONo3d[$CellContext`GGrafo]]]]]); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.6706699052954297`*^9, 3.6706699349414024`*^9}, 
   3.670670082655788*^9, 3.6706701762035484`*^9, 3.670670244929225*^9, 
   3.6706702967645035`*^9, 3.6706704036690187`*^9, {3.6706704348755827`*^9, 
   3.670670452230011*^9}, 3.801156193073761*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"3ac27c44-1803-4720-9618-76439ea5d83d"]
}, Open  ]]
},
WindowSize->{1366, 685},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"25f6b4e6-daf2-4ee2-a45d-f0c3dafff32c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 69795, 1428, 11073, "Input",ExpressionUUID->"34240ed5-103e-465d-b9f4-95021ab796c5"],
Cell[70378, 1452, 35764, 726, 632, "Output",ExpressionUUID->"3ac27c44-1803-4720-9618-76439ea5d83d"]
}, Open  ]]
}
]
*)

